<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Team;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $technicalTeam = Team::where("name", "الفريق التقني")->first();
        $mediaTeam = Team::where("name", "فريق الإعلام")->first();

        User::create([
            "name" => "admin",
            "email" => "admin@example.com",
            "password" => Hash::make("admin123"),
            "role" => "admin",
            "team_id" => null,
        ]);

        User::create([
            "name" => "ahmed_lead",
            "email" => "ahmed_lead@example.com",
            "password" => Hash::make("lead123"),
            "role" => "technical_lead",
            "team_id" => $technicalTeam->id,
        ]);

        User::create([
            "name" => "sara_lead",
            "email" => "sara_lead@example.com",
            "password" => Hash::make("lead123"),
            "role" => "media_lead",
            "team_id" => $mediaTeam->id,
        ]);

        User::create([
            "name" => "omar_dev",
            "email" => "omar_dev@example.com",
            "password" => Hash::make("vol123"),
            "role" => "volunteer",
            "team_id" => $technicalTeam->id,
        ]);

        User::create([
            "name" => "fatima_dev",
            "email" => "fatima_dev@example.com",
            "password" => Hash::make("vol123"),
            "role" => "volunteer",
            "team_id" => $technicalTeam->id,
        ]);

        User::create([
            "name" => "ali_designer",
            "email" => "ali_designer@example.com",
            "password" => Hash::make("vol123"),
            "role" => "volunteer",
            "team_id" => $mediaTeam->id,
        ]);

        User::create([
            "name" => "mona_writer",
            "email" => "mona_writer@example.com",
            "password" => Hash::make("vol123"),
            "role" => "volunteer",
            "team_id" => $mediaTeam->id,
        ]);
    }
}
